<CsoundSynthesizer>
<CsOptions>
-nm0
-odac
</CsOptions>
<CsInstruments>
sr = 44100
kr = 441
nchnls = 2
0dbfs = 1

; load GM soundbank, that also contains drums
giengine10 fluidEngine
isfnum10	 fluidLoad "./samples/003.3mg GS Roland Sound Set 16 bit Bank.SF2", giengine10, 1
fluidProgramSelect giengine10, 10, isfnum10, 128, 32

alwayson 1010

pyinit

pyruni {{
import sqlite3 as lite

sco =[]
pattern = ['Rock3', 'Bossa', '12BRock']

def getscore(i):
	global sco
	con = lite.connect('test.db')
	cur = con.cursor()
	cur.execute("SELECT score FROM scores WHERE name='%s' " % pattern[int(i)])
	rows = cur.fetchall()
	rowstring = rows[0][0]
	con.close()
	sco = rowstring.rstrip('\\n').split('\\n')
	#print sco
	return 1.0
	
def getnext(idx):
	line = sco[int(idx)]
	elms = line.split('\t')
	kwhen = float(elms[1])	# start time
	kdur = float(elms[2])	# duration
	p4 = float(elms[3])		# midi volume for drum note
	p5 = float(elms[4])		# midi drum note number
	return kwhen, kdur, p4, p5
	
#getscore(1)

}}

instr Getscore_n
ival pycall1i "getscore", p4
endin

instr Schedule_score
	kCycle timeinstk
	kIndex = 0
	;	get score length from the global python 'sco' list
	kMax pyeval "float(len(sco))"
	while kIndex < kMax do
		kwhen, kdur, kp4, kp5 pycall4 "getnext", kIndex
		;schedkwhen ktrigger, kmintim, kmaxnum, kinsnum, kwhen, kdur
		schedkwhen kIndex, 0, 1, 10, kwhen, kdur, kp4, kp5
		kIndex += 1
	od
  	;stop after first control cycle
	if kCycle == 1 then
  		turnoff
	endif
endin

instr 10  ; drums
	mididefault   60, p3
	midinoteonkey p5, p4
ikey	init p5
ivel	init p4
	fluidNote giengine10, 10, ikey, ivel
endin

instr 11
	print p2,p3, p4
	a1 oscils .8, 10*p4, 1
  	out a1
endin

instr 1010	;  play drums
imvol  init 7
asigl, asigr fluidOut giengine10
       outs asigl*imvol, asigr*imvol
endin

</CsInstruments>
<CsScore>
i "Getscore_n" 0 .1 1
i "Schedule_score" 1 15
i "Getscore_n" 16 .1 2
i "Schedule_score" 17 27
e
</CsScore>
</CsoundSynthesizer>