<CsoundSynthesizer>
<CsOptions>
-odac -dm0
--midi-device=0 -M0
</CsOptions>
<CsInstruments>
nchnls=2
0dbfs=1
massign	0,3

giReady		init	0
gitable		init	1

pyinit

pyruni {{
import sqlite3 as lite
#	global variables
midibases = [1,2,3,4,5,6]	#   will contain base midi note number for a sample
midimaxes = [1,2,3,4,5,6]	#   will contain maximum midi note number for a sample
ready = 0					# 	will be 1 when samples are loaded

con = lite.connect('test.db')

cur = con.cursor()
#cur.execute("select name, sample, midibase, midimax from samples where name like 'JazzGuitar%'")
cur.execute("select name, sample, midibase, midimax from samples where name like 'Piano%'")
all = cur.fetchall()
idx = 0
for some in all:
	name, sample, midibases[idx], midimaxes[idx] = some[0], some[1], some[2], some[3]
	with open('./samples/sample' + str(idx + 1) + '.wav', 'wb') as output_file:
	    output_file.write(sample)
	idx += 1
	
ready = 1
}} 

giReady pyevali "float(ready)"
;	get midi base and max notenumbers per sample
giMidibase1 pyevali "float(midibases[0])"
giMidibase2 pyevali "float(midibases[1])"
giMidibase3 pyevali "float(midibases[2])"
giMidibase4 pyevali "float(midibases[3])"
giMidibase5 pyevali "float(midibases[4])"
giMidibase6 pyevali "float(midibases[5])"
;print giMidibase1,giMidibase2,giMidibase3,giMidibase4,giMidibase5,giMidibase6
giMidimax1 pyevali "float(midimaxes[0])"
giMidimax2 pyevali "float(midimaxes[1])"
giMidimax3 pyevali "float(midimaxes[2])"
giMidimax4 pyevali "float(midimaxes[3])"
giMidimax5 pyevali "float(midimaxes[4])"
giMidimax6 pyevali "float(midimaxes[5])"


instr	3	; sample triggered by midi note
	;Standard guitar tuning for a six string is
	;E5/68 - B4/63 - G4/59 - D4/54 - A3/49 - E3/44
	gitable 	init 1
	iMidiRef 	init 40
 	if giReady = 1 then						; if samples have been loaded
 		icps	cpsmidi							; read in midi note data as cycles per second
 		iNote 	notnum							; also get as midi note number to determine what sample to play
     	;print iNote
 		iamp	ampmidi	1						; read in midi velocity (as a value within the range 0 - 1)
 		if iNote >= giMidibase1 && iNote <= giMidimax1 then
 			gitable = 1
 			iMidiRef = giMidibase1
 		elseif iNote >= giMidibase2 && iNote <= giMidimax2 then
 			gitable = 2
 			iMidiRef = giMidibase2
  		elseif iNote >= giMidibase3 && iNote <= giMidimax3 then
 			gitable = 3
 			iMidiRef = giMidibase3
  		elseif iNote >= giMidibase4 && iNote <= giMidimax4 then
 			gitable = 4
 			iMidiRef = giMidibase4
 		elseif iNote >= giMidibase5 && iNote <= giMidimax5 then
 			gitable = 5
 			iMidiRef = giMidibase5
 		elseif iNote >= giMidibase6 && iNote <= giMidimax6 then
 			gitable = 6
 			iMidiRef = giMidibase6
 		endif

   		;kenv	linsegr	1, .8, 0
   		kenv1	madsr	0.0001, 0, 1, 0.5
   		kenv2	madsr	0.001, 0, .9, 0.45
   		ispeed	=	icps/cpsmidinn(iMidiRef)	; derive playback speed from note played in relation to a reference note
   		;print ispeed
   		a1	loscil3		kenv1*iamp, ispeed, gitable, 1
   		a2	loscil3		kenv2*iamp, ispeed*1.0005, gitable, 1
 		outs	a1, a2		
 	endif
 
endin

</CsInstruments>
<CsScore>
f 1 0 0 1 "samples/sample1.wav" 0 0 0
f 2 0 0 1 "samples/sample2.wav" 0 0 0
f 3 0 0 1 "samples/sample3.wav" 0 0 0
f 4 0 0 1 "samples/sample4.wav" 0 0 0
f 5 0 0 1 "samples/sample5.wav" 0 0 0
f 6 0 0 1 "samples/sample6.wav" 0 0 0

f	0	3600
</CsScore>
</CsoundSynthesizer>
