#!/usr/local/bin/python2.7
#
#  	Extremely Simple Music System, using Python and Csound 
#  	by zappfinger (Richard van Bemmelen)
#	september, 2013
#

import math, os, time

waves = {'saw'	: 'i_saw ftgenonce 0, 0, 16384, 10, 1,  .5, .333,     .25, .2,   .167, .1428,   .125, .111,    .1, .0909, .0833, .0769, .0714, .0667, .0625\n', \
		 'squ'  : 'i_squ ftgenonce 0, 0, 16384, 10, 1, 0,   .333333, 0,    .2,  0,     .142857, 0,    .111111, 0,  .090909, 0, .076923\n', \
		 'tri'  : 'i_tri ftgenonce 0, 0, 16384, 10, 1, 0,   .111111, 0,    .04, 0,     .020408, 0,    .012345, 0,  .008264, 0\n', \
		 'sin'	: 'i_sin ftgenonce 0, 0, 16384, 10, 1\n', \
		 'cos'	: 'i_cos ftgenonce 0, 0, 16384, 11, 1\n'}

vcowaves = {'saw' :1, 'squ':2, 'tri':3 }

# midi notes
mnotes = {'c':60, 'c#':61, 'd':62, 'd#':63, 'eb':63, 'e':64, 'f':65, 'f#':66, 'g':67, 'g#':68, 'a':69, 'a#':70, 'bb':70, 'b':71, \
		 'c1':72,'c#1':73,'d1':74,'d#1':75,'eb1':75,'e1':76,'f1':77, 'f#1':78,'g1':79,'g#1':80,'a1':81,'a#1':82,'bb1':82,'b1':83,'c2':84}

	
class ESMS():
	def __init__(self):
		self.instr = ''			# add instrument lines to this
		self.scorelines = ''	# add score lines to this
		self.notes = {'c':7.00, 'c#':7.01, 'd':7.02, 'd#':7.03, 'eb':7.03, 'e':7.04, 'f':7.05, 'f#':7.06, 'gb':7.06, 'g':7.07, 'g#':7.08, 'a':7.09, 'a#':7.10, 'bb':7.10, 'b':7.11, \
		 'c1':8.00,'c#1':8.01,'d1':8.02,'d#1':8.03,'eb1':8.03,'e1':8.04,'f1':8.05, 'f#1':8.06,'g1':8.07,'g#1':8.08,'a1':8.09,'a#1':8.10,'bb1':8.10,'b1':8.11,'c2':9.00} 


	# we have to define some string addition and multiplication functions
	def add(self, *args):
		"""
		add(arg1, arg2, ..)
		Adds arguments, can be string or integer
		"""
		return '(' + '+'.join([str(i) for i in args]) + ')/' + str(len(args))

	def mul(self, *args):
		"""
		mul(arg1, arg2, ..)
		Multiplies arguments, can be string or integer
		"""
		return '*'.join([str(i) for i in args])

	def metro(self, kfreq=10, out = 'kfreq'):
		#   ktrig  metro  kfreq
		self.instr += '%s  metro  %s\n' % (out, kfreq)
		return out
	
	def rand(self, kmin=1, kmax=10, out='kmax'):
		#   kres random kmin, kmax
		self.instr += '%s  random  %s, %s\n' % (out, kmin, kmax)
		return out
		
	def sh(self, kpch, ktrig, out = 'kval'):
		#	kval	samphold kpch, ktrig
		self.instr += '%s  samphold  %s, %s\n' % (out, kpch, ktrig)
		return out
			
	def delvib(self, idel=.5, ivibrt=9, ivibdep=1, out ='kvib'):
		""" delayed vibrato """
		self.instr += 'kvibamp   linseg  0, %s, %s, -1\n' % (idel, ivibdep)
		self.instr += '%s oscil  kvibamp, %s, 1\n' % (out, ivibrt)
		return out
		

# oscillators

	def lfo(self, kamp, kcps=8, itype=0, out = 'klfo'):
		#   klfo/alfo   lfo kamp, kcps, itype
		self.instr += '%s lfo %s, %s, %s\n' % (out, kamp, kcps, itype)
		return out
		
	def vco(self, wave = 'saw', kamp ='p4', kcps='cpspch(p5)', kpw=0.5, out='avco'):
		# avco vco xamp, xcps, iwave, kpw
		iwave = vcowaves[wave]
		self.instr += 'isin ftgenonce 0, 0, 65536, 10, 1\n'
		self.instr += '%s vco %s, %s, %s, %s, isin\n' % (out, kamp, kcps, iwave, kpw)
		return out
		
	def gbuzz(self, kamp ='p4', kcps='cpspch(p5)', knh=10, klh=1, kmul=1, out = 'agbuzz'):
		#   agbuzz gbuzz xamp, xcps, knh, klh, kmul, ifn
		self.instr += 'icos ftgenonce 0, 0, 16384, 11, 1\n'
		self.instr += '%s  gbuzz %s, %s, %s, %s, %s, icos\n' % (out, kamp, kcps, knh, klh, kmul)
		return out
		
	def osc(self, wave='sin', kamp='p4', kcps = 'cpspch(p5)', ibas = 440, rvb = .02, pos = .5, out = 'aosc'):
		# if this is a sample 'x.wav' or 'y.aiff', use loscil for the deferred table!
		if '.wav' in wave:
			table = 'i_' + wave.split('.')[0]
			#self.instr += '%s ftgenonce 0, 0, 0, 1, "../../Desktop/ESMS/samples/%s", 0, 0, 1\n' % (table, wave)
			self.instr += '%s ftgenonce 0, 0, 0, 1, "%s", 0, 0, 1\n' % (table, wave)
			self.instr += '%s loscil %s, %s, %s, %s\n' % (out, kamp, kcps, table, ibas)
		else:
			table = 'i_' + wave
			self.instr += waves[wave]
			self.instr += '%s oscil %s, %s ,%s\n' % (out, kamp, kcps, table)	
		return out
	
# filters

	def fltMoog(self, asig, kfco=1000, kres=.2, out = 'amoog'):
		#   ares moogvcf asig, kfco, kres
		self.instr += '%s moogvcf %s,%s,%s\n' % (out, asig, kfco, kres)
		return out
			
	def lowpass(self, asig, khp=1000, out = 'alow'):
		self.instr +='%s tone %s, %s\n' % (out, asig, khp)
		return out
		
	def fltRes(self, asig, kcf = 1000, kbw = 25, out = 'ares'):
		#   ares areson asig, kcf, kbw
		self.instr += '%s areson %s,%s,%s\n' % (out, asig, kcf, kbw)
		return out

# envelopes


	def adsr(self, iattack = .0001, idecay = .01, isustain = 'p4', irelease = .2, out = 'kadsr'):
		self.instr += '%s adsr p3*%s,p3*%s,%s,p3*%s\n' % (out, iattack, idecay, isustain, irelease)
		return out
	
	def kenv(self, iatt = .0001, idec = .01, isus1 = .8, idur = 1.7, isus2=.7, irel =.1, out = 'klenv'):
		self.instr += '%s linseg 0,%s,1,%s,%s,%s,%s,%s,0\n' % (out, iatt, idec, isus1, idur, isus2, irel)
		return out

	def kline(self, istart=1, iend=0, idur='p3', out = 'kline'):
		#   kline line 0, p3, 20
		self.instr += '%s line %s, %s, %s\n' % (out, istart, idur, iend)
		return out

	def madsr(self, iatt = .0001, idec = .01, isus = 'p4', irel = 1.7, out = 'aenv'):
		# aenv madsr iattack, idecay, isustain, irelease
		self.instr += '%s madsr %s,%s,%s,%s\n' % (out, iatt, idec, isus, irel)
		return out
		
	def declick(self, ain='ain', len='p3', out='adecl'):
		self.instr += 'aenv  linseg 0, 0.02, 1, %s - 0.05, 1, 0.02, 0, 0.01, 0\n' % len
		self.instr += '%s = %s * aenv\n' % (out, ain)         # apply envelope and write output
		return out
		
	def expon(self, istart=.9, idur=.2, iend=.001, out = 'kexp'):
		#   kr   expon      ia, idur1, ib
		self.instr += '%s expon %s, %s, %s\n' % (out, istart, idur, iend)
		return out
		
	def midiEnv(self, kamp='p4', irise=.01, idec=.1, iatdec=.01, out='kmenv'):
		#   aenv	    linenr    iamp, .01, .1, .01 	  ;envelope
		self.instr += '%s linenr %s,%s,%s,%s\n' % (out, kamp, irise, idec, iatdec)
		return out

# output

	def panout(self, asig='asig', kpan='kpan'):
		self.instr += 'kpan2 = %s*3.14159265*.5\n' % kpan
		self.instr += 'kpanl = sin(kpan2)\n'
		self.instr += 'kpanr = cos(kpan2)\n'
		self.instr += 'outs   kpanl*%s, kpanr*%s' % (asig, asig)
		return self.instr
		
	def panmix(self, asig='asig', kpan='kpan'):
		self.instr += 'kpan2 = %s*3.14159265*.5\n' % kpan
		self.instr += 'kpanl = sin(kpan2)\n'
		self.instr += 'kpanr = cos(kpan2)\n'
		self.instr += 'blueMixerOut kpanl*%s, kpanr*%s' % (asig, asig)
		return self.instr
		
	def outs(self, aL, aR = 0, vol=[.8,.8]):
		if aR == 0:
			self.instr += 'outs %s*%s,%s*%s\n' % (aL, vol[0], aL, vol[1])
		else:
			self.instr += 'outs %s*%s,%s*%s\n' % (aL, vol[0], aR, vol[1])
		return self.instr

	def bluemix(self, aL, aR = 0, vol=[.8,.8]):
		if aR == 0:
			self.instr += 'blueMixerOut %s*%s, %s*%s\n' % (aL, vol[0], aL, vol[1])
		else:
			self.instr += 'blueMixerOut %s*%s, %s*%s\n' % (aL, vol[0], aR, vol[1])
		return self.instr
		
# chord and note generation...

	def chord(self, chordDict, instrNr, chNam, start = 0, length = 1, ampl = .8, transp = 0):
		chordL = ''
		if chNam in chordDict:
			for nots in chordDict[chNam]:
				chordL += self.note(instrNr, str(nots), start, length, ampl, transp)
		return chordL

	def note(self, instrNr=1, noteNam='c', start = 0, length = 1, ampl = .8, transp = 0):
		if noteNam in self.notes:
			noteL = 'i%s\t%s\t%s\t%s\t%s\r\n' % (instrNr, start, length, ampl, self.notes[noteNam] + transp)		
		return noteL
			
	def getinstrTime(self, pattern):
		if ':' in pattern:
			instrlen, pat = pattern.split(':')
			instr,nstart = instrlen.split('@')
			instrNr = int(instr)
			notestart = float(nstart)
		else:
			instrNr = 1
			notestart = 0.0
		return pat, instrNr, notestart
			
	def ParseChords(self, cd, pattern, times=1, length=.125, vol = 1, trans=0):
		#  pat = '1@.25: G7 , C7 .|'   instr 1, start length =0.25 
		chordL = '\n'
		pat, instrNr, notestart = self.getinstrTime(pattern)
		workpat = pat
		print notestart, length, pat
		if times>1:
			for i in range (1,times):
				workpat = workpat + pat 

		patt = workpat.split(' ')
		print patt
		pos = 0 
		for elm in patt:
			if elm == '|':
				pass
			elif elm =='.':		# repeat last 
				#ch = last
				chordL += self.chord(cd, instrNr, last, pos, length, ampl=vol, transp=trans)
				pos = pos + notestart
			elif elm ==',':		# rest, only advance 
				pos = pos + notestart
			elif len(elm) <>0:
				#print len(elm), elm
				chordL += self.chord(cd, instrNr, elm, pos, length, ampl=vol, transp=trans)
				pos = pos + notestart
				last = elm	
		return chordL
		
	def ParseMelody(self, pattern, times=1, length = .25, transpose = 0, vol = .9):
		#  pat = '1@.5: c e g a|'   instr 1, start length =0.5 
		melLine = '\n'
		pat, instrNr, notestart = self.getinstrTime(pattern)
		workpat = pat
		if times>1:
			for i in range (1,times):
				workpat = workpat + pat 

		patt = workpat.split(' ')
		pos = 0 
		for elm in patt:
			if elm == '|':
				pass
			elif elm =='.':		# repeat last 
				#ch = last
				melLine += self.note(instrNr, last, pos, length, ampl = vol, transp = transpose)
				pos = pos + notestart
			elif elm ==',':		# rest, only advance 
				pos = pos + notestart
			elif len(elm)<>0:
				melLine += self.note(instrNr, elm, pos, length, ampl = vol, transp = transpose)
				pos = pos + notestart
				last = elm
		return melLine
		
	def ramp(self, score, start=1, end=.6, p=4):
		CRLF = '\r\n'
		diff = start - end
		lines = []
		if score:
			lines = score.split(CRLF)
			n = len(lines) - 2
			delta = 0
			lev = start
			scorel = []
			for line in lines:
				if '\t' in line:
					lev = lev - delta
					elms = line.split('\t')
					elms[p-1] = str(float(elms[p-1])*lev)
					delta = diff/n
					scorel.append('\t'.join(elms))
					print lev
				newscore = CRLF.join(scorel)
			return newscore

# rep repeats a score n times
			
	def rep(self, score, times=8):
		CRLF = '\r\n'
		scorelines = score.split(CRLF)
		timelst = []
		newscorelst = []
		for scoreline in scorelines:
			if '\t' in scoreline:
				elms = scoreline.split('\t')
				timelst.append(elms[1])	# get times (p2)
				end = elms[1]			# save end time
		delta = float(timelst[1]) - float(timelst[0])
		newscore = score				# start with original score
		start = float(end)
		for i in range(1, times):		# append times - 1
			for scoreline in scorelines:
				if '\t' in scoreline:
					elms = scoreline.split('\t')
					start = start + delta	
					elms[1] = str(start) 		# add delta to p2
					newscorelst.append('\t'.join(elms))
		morescore = CRLF.join(newscorelst)		
		newscore = newscore + morescore
		return newscore
		
	

# create an instance of ESMS
c = ESMS()
# we can't use c.vco(), because that would call the function, we want the adress only
vco = c.vco
lfo = c.lfo
osc = c.osc
gbuzz = c.gbuzz
fltMoog = c.fltMoog
fltRes = c.fltRes
lowpass = c.lowpass
outs = c.outs
mul = c.mul
add = c.add
metro = c.metro
rand = c.rand
sh = c.sh
expon = c.expon
declick = c.declick
kline = c.kline
midiEnv = c.midiEnv
madsr = c.madsr
adsr = c.adsr
panouts = c.panout
panmix = c.panmix
bluemix = c.bluemix
delvib = c.delvib
# score section
ParseChords = c.ParseChords
ParseMelody = c.ParseMelody
notes = c.notes
ramp = c.ramp
rep = c.rep

	
